import flet as ft


def main(page: ft.Page):
    page.title = "Drag and Drop – простой пример"

    def drag_accept(e):
        # Перетаскиваемый элемент по его ID
        src = page.get_control(e.src_id)

        # Меняем тексты
        src.content.content.value = "0"
        e.control.content.content.value = "1"

        page.update()

    page.add(
        ft.Row(
            [
                ft.Draggable(
                    group="number",
                    content=ft.Container(
                        width=50,
                        height=50,
                        bgcolor=ft.Colors.CYAN_200,
                        border_radius=5,
                        alignment=ft.alignment.center,
                        content=ft.Text("1", size=20),
                    ),
                ),
                ft.Container(width=100),
                ft.DragTarget(
                    group="number",
                    content=ft.Container(
                        width=50,
                        height=50,
                        bgcolor=ft.Colors.PINK_200,
                        border_radius=5,
                        alignment=ft.alignment.center,
                        content=ft.Text("0", size=20),
                    ),
                    on_accept=drag_accept,
                ),
            ]
        )
    )


if __name__ == "__main__":
    ft.app(target=main)
